/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class DogFollowOwnerGoal
extends Goal {
    private final Dog dog;
    private final Level world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;

    public DogFollowOwnerGoal(Dog dogIn, double speedIn, float minDistIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.m_9236_();
        this.followSpeed = speedIn;
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null) {
            return false;
        }
        if (!this.dog.getMode().shouldFollowOwner()) {
            return false;
        }
        if (owner.m_5833_()) {
            return false;
        }
        if (this.dog.m_21825_()) {
            return false;
        }
        if (!this.dog.hasBone() && this.dog.m_20280_((Entity)owner) < (double)this.getMinStartDistanceSq()) {
            return false;
        }
        if (this.dog.getDogSitOverridePos().isPresent()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean m_8045_() {
        if (this.dog.m_21573_().m_26571_()) {
            return false;
        }
        if (this.dog.m_21825_()) {
            return false;
        }
        return this.dog.m_20280_((Entity)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
        this.dog.setDogFollowingSomeone(true);
    }

    public void m_8041_() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.m_20280_((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.m_5552_(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.f_41583_);
        }
        this.owner = null;
        this.dog.m_21573_().m_26573_();
        this.dog.setDogFollowingSomeone(false);
    }

    public void m_8037_() {
        this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.dog.isDogFlying() ? 5 : 10;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, true, --this.tickTillSearchForTp <= 0, 400.0, this.dog.m_6056_());
            if (this.tickTillSearchForTp <= 0) {
                this.tickTillSearchForTp = 10;
            }
        }
    }

    public float getMinStartDistanceSq() {
        return this.startDist * this.startDist;
    }
}

